/* asread.c - Wait for SVC connections to a SAP in a loop;
 *            on an incoming connection read one AAL5 PDU, print
 *            contents, close connection and repeat.
 */


/* Original read.c written 1995,1996 by Werner Almesberger, EPFL-LRC
 * This version 1997,1998 by Juhana Rsnen, HUT/TCM
 */


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/atm.h>
#include <atm.h>

#define BSIZE 1024

void listenLoop(const char *sap_);


static void usage(const char *name)
{
    fprintf(stderr, "usage: %s localSAP\n", name);
    fprintf(stderr, "localSAP is an arbitrary 16-bit integer (0-65535)\n");
    exit(1);
}


int main(int argc, char *argv[])
{
    if (argc != 2) usage(argv[0]);
    listenLoop(argv[1]);

    return 0;
}


void listenLoop(const char *sap_)
{
    struct sockaddr_atmsvc addr;
    struct atm_qos qos;
    struct atm_blli blli;
    int descriptor;
    int realDescriptor;
    int addrlen;
    int size,i;
    unsigned char buf[BSIZE];

    descriptor = socket(PF_ATMSVC, SOCK_DGRAM, ATM_AAL5);
    if (descriptor < 0)
    {
        perror("socket");
        exit(1);
    }

    memset(&qos, 0, sizeof(qos));
    qos.txtp.traffic_class = ATM_ANYCLASS;
    qos.rxtp = qos.txtp;
    if (setsockopt(descriptor, SOL_ATM, SO_ATMQOS, &qos, sizeof(qos)) < 0)
    {
        perror("setsockopt");
        exit(1);
    }

    memset(&addr, 0, sizeof(addr));
    addr.sas_family = AF_ATMSVC;

    blli.l2_proto = ATM_L2_NONE;
    blli.l3_proto = ATM_L3_USER;
    blli.l3.user = (unsigned char) atoi(sap_);
    blli.next = 0;
    addr.sas_addr.blli = &blli;
    addr.sas_addr.bhli.hl_type = ATM_HL_NONE;
 
    if (bind(descriptor, (struct sockaddr *) &addr, sizeof(addr)) < 0)
    {
        perror("bind");
        exit(1);
    }

    if (listen(descriptor, 1) < 0)
    {
      perror("listen");
      exit(1);
    }

    while (1)
    {
      if ((realDescriptor =
	   accept(descriptor, (struct sockaddr *) &addr, &addrlen)) < 0)
      {
	perror("accept");
	exit(1);
      }

      size = read(realDescriptor, buf, BSIZE);
      if (size < 0)
      {
	perror("read");
	exit(1);
      }

      buf[size] = '\0';
      printf("%s", buf);
      
      if (close(realDescriptor) < 0)
      {
	perror("close");
	exit(1);
      }
    }

    return;
}
