/* aswrite.c - Open an SVC connection to given SAP/addr, write one
 *             AAL5 PDU (containing sequence number) the the connection,
 *             close connection, wait for given time and repeat.
 */

/* Original write.c written 1995,1996 by Werner Almesberger, EPFL-LRC
 * This version 1997,1998 by Juhana Rsnen, HUT/TCM
 */


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/atm.h>
#include <atm.h>


static void usage(const char *name)
{
    fprintf(stderr, "usage: %s phoneNo SAP [delay in ms]\n", name);
    fprintf(stderr, "phoneNo is the remote ATM address in numerical form\n");
    fprintf(stderr, "SAP is an arbitrary 16-bit integer (0-65535)\n");
    fprintf(stderr, "Delay is the delay between calls (default 500 ms)\n");
    exit(1);
}


int main(int argc, char *argv[])
{
    struct sockaddr_atmsvc addr;
    struct atm_qos qos;
    struct atm_blli blli;
    int s,size,offset,counter = 0;
    char buffer[256];
    int delay = 500;

    if ((argc < 3) || (argc > 4)) usage(argv[0]);
    if (argc == 4) {
      delay = atoi(argv[3]);
    }

    /* Convert to microseconds for usleep() system call */
    delay = delay * 1000;

    memset(&addr,0,sizeof(addr));
    addr.sas_family = AF_ATMSVC;

    if (text2atm(argv[1], (struct sockaddr *)&addr, sizeof(addr), T2A_SVC) < 0)
    {
      perror("text2atm");
      exit(1);
    }

    /* Define the SAP in the BLLI */
    memset(&blli, 0, sizeof(struct atm_blli));
    blli.l2_proto = ATM_L2_NONE;
    blli.l3_proto = ATM_L3_USER;
    blli.l3.user = (unsigned char) atoi(argv[2]);
    blli.next = 0;
    addr.sas_addr.blli = &blli;
    addr.sas_addr.bhli.hl_type = ATM_HL_NONE;
 
    memset(&qos,0,sizeof(qos));
    qos.txtp.traffic_class = ATM_UBR;
    qos.txtp.max_sdu = 256;
    qos.rxtp = qos.txtp;

    while (1) {
      if ((s = socket(PF_ATMSVC,SOCK_DGRAM,ATM_AAL5)) < 0) {
	perror("socket");
	return 1;
      }
      if (setsockopt(s,SOL_ATM,SO_ATMQOS,&qos,sizeof(qos)) < 0) {
	perror("setsockopt SO_ATMQOS");
	return 1;
      }

      if (connect(s, (struct sockaddr *) &addr, sizeof(addr)) < 0) {
	perror("connect");
	return 1;
      }

      sprintf(buffer, "%d\n", counter);
      write(s, buffer, strlen(buffer));

      if (close(s) < 0) {
	perror("close");
	return 1;
      }

      counter++;
      usleep(delay);
    }

    return 0;
}
